/*
 * Decompiled with CFR 0.152.
 */
package app.f3d.F3D;

import java.util.List;

public class Image {
    private long mNativeAddress;

    public Image(String string) {
        this.mNativeAddress = Image.nativeCreateFromFile(string);
    }

    public Image(int n, int n2, int n3, ChannelType channelType) {
        this.mNativeAddress = Image.nativeCreate(n, n2, n3, channelType.ordinal());
    }

    public Image(int n, int n2, int n3) {
        this(n, n2, n3, ChannelType.BYTE);
    }

    Image(long l) {
        this.mNativeAddress = l;
    }

    public native double[] getNormalizedPixel(int var1, int var2);

    public static native List<String> getSupportedFormats();

    public native int getWidth();

    public native int getHeight();

    public native int getChannelCount();

    public native ChannelType getChannelType();

    public native int getChannelTypeSize();

    public native Image setContent(byte[] var1);

    public native byte[] getContent();

    public native double compare(Image var1);

    public boolean equals(Image image) {
        return this.compare(image) < 1.0E-14;
    }

    public boolean notEquals(Image image) {
        return this.compare(image) >= 1.0E-14;
    }

    public native Image save(String var1, SaveFormat var2);

    public Image save(String string) {
        return this.save(string, SaveFormat.PNG);
    }

    public native byte[] saveBuffer(SaveFormat var1);

    public byte[] saveBuffer() {
        return this.saveBuffer(SaveFormat.PNG);
    }

    public native String toTerminalText();

    public native Image setMetadata(String var1, String var2);

    public native String getMetadata(String var1);

    public native List<String> allMetadata();

    public void delete() {
        if (this.mNativeAddress != 0L) {
            Image.nativeDestroy(this.mNativeAddress);
            this.mNativeAddress = 0L;
        }
    }

    private static native long nativeCreateFromFile(String var0);

    private static native long nativeCreate(int var0, int var1, int var2, int var3);

    private static native void nativeDestroy(long var0);

    static {
        System.loadLibrary("f3d-java");
    }

    public static enum ChannelType {
        BYTE,
        SHORT,
        FLOAT;

    }

    public static enum SaveFormat {
        PNG,
        JPG,
        TIF,
        BMP;

    }
}

