/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.app;

import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.impl.app.BaseProjectImpl;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.task.TaskManagerImpl;

public class DPIVirtualProject
extends BaseProjectImpl {
    private final String projectName;

    public DPIVirtualProject(@NotNull DBPWorkspace workspace, @Nullable SMSessionContext sessionContext, String projectName) {
        super(workspace, sessionContext);
        this.projectName = projectName;
    }

    public boolean isVirtual() {
        return true;
    }

    @NotNull
    public String getName() {
        return this.projectName;
    }

    @NotNull
    public Path getAbsolutePath() {
        return Path.of(this.projectName, new String[0]);
    }

    public boolean isOpen() {
        return true;
    }

    public void ensureOpen() {
    }

    public boolean isUseSecretStorage() {
        return false;
    }

    @NotNull
    public DBTTaskManager getTaskManager() {
        return new TaskManagerImpl((BaseProjectImpl)this, this.getWorkspace().getMetadataFolder().resolve("task-stats"));
    }

    @NotNull
    protected DBPDataSourceRegistry createDataSourceRegistry() {
        return new DataSourceRegistry((DBPProject)this);
    }
}

