/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H$J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler;", "", "<init>", "()V", "requests", "Lkotlinx/coroutines/flow/Flow;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$PreviewRequest;", "getRequests", "()Lkotlinx/coroutines/flow/Flow;", "addRequest", "", "request", "setContent", "", "content", "", "initialScrollOffset", "", "document", "Lcom/intellij/openapi/vfs/VirtualFile;", "reloadWithOffset", "offset", "doRequest", "PreviewRequest", "Debounced", "intellij.markdown"})
public abstract class MarkdownUpdateHandler {
    @NotNull
    public abstract Flow<PreviewRequest> getRequests();

    protected abstract boolean addRequest(@NotNull PreviewRequest var1);

    public final void setContent(@NotNull String content2, int initialScrollOffset, @Nullable VirtualFile document) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.doRequest(new PreviewRequest.Update(content2, initialScrollOffset, document));
    }

    public final void reloadWithOffset(int offset) {
        this.doRequest(new PreviewRequest.ReloadWithOffset(offset));
    }

    private final void doRequest(PreviewRequest request) {
        if (!this.addRequest(request)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0014R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$Debounced;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler;", "debounceTimeout", "Lkotlin/time/Duration;", "<init>", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "_updateViewRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$PreviewRequest;", "requests", "Lkotlinx/coroutines/flow/Flow;", "getRequests", "()Lkotlinx/coroutines/flow/Flow;", "addRequest", "", "request", "intellij.markdown"})
    public static final class Debounced
    extends MarkdownUpdateHandler {
        private final long debounceTimeout;
        @NotNull
        private final MutableSharedFlow<PreviewRequest> _updateViewRequests;

        private Debounced(long debounceTimeout) {
            this.debounceTimeout = debounceTimeout;
            this._updateViewRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        }

        public /* synthetic */ Debounced(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.MILLISECONDS);
            }
            this(l, null);
        }

        @Override
        @NotNull
        public Flow<PreviewRequest> getRequests() {
            return FlowKt.debounce-HG0u8IE((Flow)((Flow)this._updateViewRequests), (long)this.debounceTimeout);
        }

        @Override
        protected boolean addRequest(@NotNull PreviewRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            return this._updateViewRequests.tryEmit((Object)request);
        }

        public /* synthetic */ Debounced(long debounceTimeout, DefaultConstructorMarker $constructor_marker) {
            this(debounceTimeout);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$PreviewRequest;", "", "Update", "ReloadWithOffset", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$PreviewRequest$ReloadWithOffset;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$PreviewRequest$Update;", "intellij.markdown"})
    public static sealed interface PreviewRequest {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$PreviewRequest$ReloadWithOffset;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$PreviewRequest;", "offset", "", "<init>", "(I)V", "getOffset", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.markdown"})
        public static final class ReloadWithOffset
        implements PreviewRequest {
            private final int offset;

            public ReloadWithOffset(int offset) {
                this.offset = offset;
            }

            public final int getOffset() {
                return this.offset;
            }

            public final int component1() {
                return this.offset;
            }

            @NotNull
            public final ReloadWithOffset copy(int offset) {
                return new ReloadWithOffset(offset);
            }

            public static /* synthetic */ ReloadWithOffset copy$default(ReloadWithOffset reloadWithOffset, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = reloadWithOffset.offset;
                }
                return reloadWithOffset.copy(n);
            }

            @NotNull
            public String toString() {
                return "ReloadWithOffset(offset=" + this.offset + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.offset);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReloadWithOffset)) {
                    return false;
                }
                ReloadWithOffset reloadWithOffset = (ReloadWithOffset)other;
                return this.offset == reloadWithOffset.offset;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$PreviewRequest$Update;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownUpdateHandler$PreviewRequest;", "content", "", "initialScrollOffset", "", "document", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/lang/String;ILcom/intellij/openapi/vfs/VirtualFile;)V", "getContent", "()Ljava/lang/String;", "getInitialScrollOffset", "()I", "getDocument", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.markdown"})
        public static final class Update
        implements PreviewRequest {
            @NotNull
            private final String content;
            private final int initialScrollOffset;
            @Nullable
            private final VirtualFile document;

            public Update(@NotNull String content2, int initialScrollOffset, @Nullable VirtualFile document) {
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                this.content = content2;
                this.initialScrollOffset = initialScrollOffset;
                this.document = document;
            }

            @NotNull
            public final String getContent() {
                return this.content;
            }

            public final int getInitialScrollOffset() {
                return this.initialScrollOffset;
            }

            @Nullable
            public final VirtualFile getDocument() {
                return this.document;
            }

            @NotNull
            public final String component1() {
                return this.content;
            }

            public final int component2() {
                return this.initialScrollOffset;
            }

            @Nullable
            public final VirtualFile component3() {
                return this.document;
            }

            @NotNull
            public final Update copy(@NotNull String content2, int initialScrollOffset, @Nullable VirtualFile document) {
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                return new Update(content2, initialScrollOffset, document);
            }

            public static /* synthetic */ Update copy$default(Update update, String string, int n, VirtualFile virtualFile, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = update.content;
                }
                if ((n2 & 2) != 0) {
                    n = update.initialScrollOffset;
                }
                if ((n2 & 4) != 0) {
                    virtualFile = update.document;
                }
                return update.copy(string, n, virtualFile);
            }

            @NotNull
            public String toString() {
                return "Update(content=" + this.content + ", initialScrollOffset=" + this.initialScrollOffset + ", document=" + this.document + ")";
            }

            public int hashCode() {
                int result = this.content.hashCode();
                result = result * 31 + Integer.hashCode(this.initialScrollOffset);
                result = result * 31 + (this.document == null ? 0 : this.document.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Update)) {
                    return false;
                }
                Update update = (Update)other;
                if (!Intrinsics.areEqual((Object)this.content, (Object)update.content)) {
                    return false;
                }
                if (this.initialScrollOffset != update.initialScrollOffset) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.document, (Object)update.document);
            }
        }
    }
}

